/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamParent;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSParamChoices
extends WSParamParent {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParamChoices";
    protected Vector m_choices = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                if (this.m_choices != null) {
                    Vector choices = this.m_choices;
                    this.m_choices = null;
                    WSParam param = null;
                    for (int i = choices.size() - 1; i >= 0; --i) {
                        param = (WSParam)choices.remove(i);
                        if (param == null) continue;
                        param.releaseReferences();
                    }
                    param = null;
                    choices = null;
                }
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParamChoices(WSParamParent parent, String name, String namespace, String typeNSPrefix, String typeName) {
        super(parent, name, namespace, typeNSPrefix, typeName);
        this.m_bBaseType = false;
    }

    public WSParamChoices(WSParamParent parent) {
        super(parent);
    }

    public void addChoice(WSParam param) {
        if (this.m_choices == null) {
            this.m_choices = new Vector();
        }
        if (param != null) {
            this.m_choices.add(param);
        }
    }

    public void addChoice(Vector params) {
        if (params != null && params.size() > 0) {
            if (this.m_choices == null) {
                this.m_choices = new Vector();
            }
            this.m_choices.add(params);
        }
    }

    public WSParam[] getChoices() {
        if (this.m_choices != null && this.m_choices.size() > 0) {
            WSParam[] choices = new WSParam[this.m_choices.size()];
            this.m_choices.toArray(choices);
            return choices;
        }
        return null;
    }

    public void addChild(WSParam param) {
    }

    public boolean setChoice(int index) {
        Object obj;
        if (this.m_choices != null && index >= 0 && index < this.m_choices.size() && (obj = this.m_choices.get(index)) != null && obj instanceof WSParam) {
            this.reset();
            this.m_children = new Vector();
            this.m_children.add(((WSParam)obj).clone(this));
            return true;
        }
        return false;
    }

    public WSParam getSelectedChoice() {
        Object obj;
        if (this.m_children != null && this.m_children.size() > 0 && (obj = this.m_children.get(0)) != null && obj instanceof WSParam) {
            return (WSParam)obj;
        }
        return null;
    }

    protected boolean isSameNamespace(String namespace) {
        return this.m_parent.isSameNamespace(namespace);
    }

    protected void copyTo(WSParamChoices to) {
        super.copyTo(to);
        if (this.m_choices != null) {
            Object obj = null;
            Object param = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                obj = this.m_choices.elementAt(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                to.addChoice(((WSParam)obj).clone(this));
            }
        }
    }

    protected WSParam clone(WSParamParent parent) {
        WSParamChoices clone = new WSParamChoices(parent, this.getName(), this.getNamespace(), this.getTypeNamespacePrefix(), this.getTypeName());
        this.copyTo(clone);
        return clone;
    }

    public String toXML() {
        String s = new String();
        if (this.m_choices != null && this.m_choices.size() > 0) {
            s = s + "<!--Use one of the choices-->\n";
            s = s + "<!--Begin choices-->\n";
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                s = s + "\n<!--Begin choice " + i + "-->\n";
                obj = this.m_choices.get(i);
                if (obj != null && obj instanceof WSParam) {
                    s = s + ((WSParam)obj).toXML();
                }
                s = s + "<!--End choice " + i + "-->\n";
            }
            s = s + "<!--End choices-->\n";
        }
        s = s + ">\n";
        return s;
    }

    public String toXMLTemplate() {
        String s = new String();
        if (this.m_choices != null && this.m_choices.size() > 0) {
            s = s + "<!--Use one of the choices-->\n";
            s = s + "<!--Begin choices-->\n";
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                s = s + "\n<!-- Begin choice " + i + "-->\n";
                obj = this.m_choices.get(i);
                if (obj != null && obj instanceof WSParam) {
                    s = s + ((WSParam)obj).toXMLTemplate();
                }
                s = s + "<!--End choice " + i + "-->\n";
            }
        }
        s = s + ">\n";
        return s;
    }

    protected Element createTemplateElement(Document doc, int bindingStyle) {
        Element element = super.createTemplateElement(doc, bindingStyle);
        if (this.m_choices != null && this.m_choices.size() > 0) {
            element.appendChild(doc.createComment("Use one of the choices"));
            element.appendChild(doc.createComment("Begin choices"));
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                element.appendChild(doc.createComment("Begin choice " + i));
                obj = this.m_choices.get(i);
                if (obj != null && obj instanceof WSParam) {
                    element.appendChild(((WSParam)obj).createTemplateElement(doc, bindingStyle));
                }
                element.appendChild(doc.createComment("End choice " + i));
            }
            element.appendChild(doc.createComment("End choices"));
        }
        return element;
    }

    protected void addTemplateElement(Document doc, Element pElement, int bindingStyle) {
        if (this.m_choices != null && this.m_choices.size() > 0) {
            pElement.appendChild(doc.createComment("Use one of the choices"));
            pElement.appendChild(doc.createComment("Begin choices"));
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                pElement.appendChild(doc.createComment("Begin choice " + i));
                obj = this.m_choices.get(i);
                if (obj != null && obj instanceof WSParam) {
                    ((WSParam)obj).addTemplateElement(doc, pElement, bindingStyle);
                }
                pElement.appendChild(doc.createComment("End choice " + i));
            }
            pElement.appendChild(doc.createComment("End choices"));
        }
    }

    public String toString() {
        String s = new String("******** Choice *******\n");
        s = s + super.toString();
        if (this.m_choices != null && this.m_choices.size() > 0) {
            s = s + "Choices : ";
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                obj = this.m_choices.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                s = s + "Choice[" + i + "] - \n";
                s = s + ((WSParam)obj).toString();
            }
        }
        s = s + "******** end of " + this.getName() + "\n\n";
        return s;
    }

    protected Vector getFlatParamList() {
        Vector list = new Vector();
        Vector subList = null;
        if (this.m_choices != null && this.m_choices.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                obj = this.m_choices.elementAt(i);
                if (obj == null || !(obj instanceof WSParam) || (subList = ((WSParam)obj).getFlatParamList()) == null) continue;
                list.addAll(subList);
            }
        }
        return list;
    }

    protected void populate(Node node) {
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            Object obj = null;
            Node[] nodes = null;
            WSParam choice = null;
            if (this.m_choices != null && this.m_choices.size() > 0) {
                for (int i = 0; i < this.m_choices.size(); ++i) {
                    obj = this.m_choices.get(i);
                    nodes = null;
                    if (obj != null && obj instanceof WSParam && (nodes = WSParam.findNodes(childNodes, ((WSParam)obj).getName())) != null && nodes.length > 0) {
                        for (int j = 0; j < nodes.length; ++j) {
                            if (nodes[j] == null) continue;
                            this.setChoice(i);
                            choice = this.getSelectedChoice();
                            choice.populate(nodes[j]);
                        }
                    }
                    if (choice != null) break;
                }
            }
        }
    }

    public boolean isChoice() {
        return true;
    }

    public void reset() {
        super.reset();
        if (this.m_children != null) {
            this.m_children.removeAllElements();
        }
    }

    public void removeAll() {
        super.removeAll();
        if (this.m_choices != null && this.m_choices.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                obj = this.m_choices.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                ((WSParam)obj).removeAll();
            }
            this.m_choices.removeAllElements();
            this.m_choices = null;
        }
    }
}

